/*
 
 File: GenesysMobileServiceRequest.java
 Abstract: Encapsulates request content to be sent to Genesys Mobile Services
 
 Version: 1.0
 
 Disclaimer: IMPORTANT:  This software is supplied to you by Genesys
 Telecommunications Laboratories Inc ("Genesys") in consideration of your agreement
 to the following terms, and your use, installation, modification or redistribution
 of this Genesys software constitutes acceptance of these terms.  If you do not
 agree with these terms, please do not use, install, modify or redistribute this
 Genesys software.
 
 In consideration of your agreement to abide by the following terms, and subject
 to these terms, Genesys grants you a personal, non-exclusive license, under
 Genesys's copyrights in this original Genesys software (the "Genesys Software"), to
 use, reproduce, modify and redistribute the Genesys Software, with or without
 modifications, in source and/or binary forms; provided that if you redistribute
 the Genesys Software in its entirety and without modifications, you must retain
 this notice and the following text and disclaimers in all such redistributions
 of the Genesys Software.
 
 Neither the name, trademarks, service marks or logos of Genesys Inc. may be used
 to endorse or promote products derived from the Genesys Software without specific
 prior written permission from Genesys.  Except as expressly stated in this notice,
 no other rights or licenses, express or implied, are granted by Genesys herein,
 including but not limited to any patent rights that may be infringed by your
 derivative works or by other works in which the Genesys Software may be
 incorporated.
 
 The Genesys Software is provided by Genesys on an "AS IS" basis.  GENESYS MAKES NO
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, REGARDING THE GENESYS SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
 COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL GENESYS BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR
 DISTRIBUTION OF THE GENESYS SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF
 CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF
 GENESYS HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 Copyright (C) 2012 Genesys Inc. All Rights Reserved.
 
 */

package com.genesyslab.gms.android.framework;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class GenesysMobileServiceRequest {
	ByteArrayOutputStream requestBody;
    final String boundary = "--AaB03x\r\nContent-Disposition: form-data; name="; //Multipart form boundary
    boolean isSent = false;
	
	public GenesysMobileServiceRequest() {
		requestBody = new ByteArrayOutputStream();
	}
	
	/**
	 * Sets the value for a named parameter to an NSData object with a specific MIME type
	 * @throws IOException Error adding attachment
	 */
	public void addAttachment(InputStream data, String mimeType, String fileName, String paramName) throws IOException {
		if (isSent) {
			throw new IOException("Request already serialized. Create a new request");
		}
		
	    String part = boundary + "\"" + paramName + "\"; filename=\"" + fileName + "\"\r\nContent-Type:" + mimeType + "\r\n\r\n"; //Multipart form boundary

	    requestBody.write(part.getBytes());	
	    
	    //Write out the binary stream
	    int val;  	    
	    while ((val = data.read()) != -1)  
	      requestBody.write(val);  
	    
	    requestBody.write("\r\n".getBytes());
	}

	/**
	 * Add a Name/Value pair
	 * @throws IOException Error adding parameter
	 */
	public void addValue(String paramName, String paramValue) throws IOException {
		if (isSent) {
			throw new IOException("Request already serialized. Create a new request");
		}
		
		String part = boundary + "\"" + paramName + "\"\r\n\r\n" + paramValue + "\r\n";
		requestBody.write(part.getBytes());
	}

	/**
	 * Get the Request Body as string
	 */
	 public String getRequestBodyAsString() {
		 String request = new String(requestBody.toByteArray()) + "--AaB03x--\r\n";
		 return request;
	 }

	/**
	 * Get the Request Body as stream
	 */
	ByteArrayOutputStream getRequestBodyAsStream() throws IOException {
		if (!isSent) {
		    requestBody.write("--AaB03x--\r\n".getBytes());
		    isSent = true;
		}
		return requestBody;
	}
}
